<?php
// bootstrap.php - DB connection, session, helpers
session_start();

$CFG = [
  'db_host' => '127.0.0.1',
  'db_name' => 'mms',
  'db_user' => 'root',
  'db_pass' => '',
  'site_url' => '', // set your base url, e.g. https://example.com/mms
  'upload_dir' => __DIR__ . '/../public/uploads'
];

try {
    $pdo = new PDO("mysql:host={$CFG['db_host']};dbname={$CFG['db_name']};charset=utf8mb4", $CFG['db_user'], $CFG['db_pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('DB Error: ' . $e->getMessage());
}

function isLogged() { return !empty($_SESSION['user_id']); }
function currentUserId() { return $_SESSION['user_id'] ?? null; }
function currentUserRole() { return $_SESSION['user_role'] ?? null; }

function canAccess($element) {
    global $pdo;
    $role = currentUserRole();
    if ($role === 'superadmin') return true;
    $stmt = $pdo->prepare('SELECT allowed FROM permissions WHERE role = ? AND element = ? LIMIT 1');
    $stmt->execute([$role, $element]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    return $row && $row['allowed'];
}

function getSetting($key) {
    global $pdo;
    $stmt = $pdo->query('SELECT * FROM system_settings LIMIT 1');
    $r = $stmt->fetch(PDO::FETCH_ASSOC);
    return $r[$key] ?? null;
}

function setFlash($msg) { $_SESSION['_flash'] = $msg; }
function getFlash() { $m = $_SESSION['_flash'] ?? null; unset($_SESSION['_flash']); return $m; }

?>