<?php
require_once __DIR__ . '/bootstrap.php';
function generate_invoice_html($invoice_id){
  global $pdo;
  $stmt=$pdo->prepare('SELECT i.*, u.username, u.email FROM invoices i JOIN users u ON u.id=i.member_id WHERE i.id=?'); $stmt->execute([$invoice_id]); $inv=$stmt->fetch(PDO::FETCH_ASSOC);
  if(!$inv) return false;
  $org = $pdo->query('SELECT * FROM system_settings LIMIT 1')->fetch(PDO::FETCH_ASSOC);
  $html = "<html><body>";
  $html .= "<div style='text-align:center'><h2>".htmlspecialchars($org['organization_name'] ?? 'Organization')."</h2>";
  if(!empty($org['organization_logo'])) $html .= "<img src='".htmlspecialchars($org['organization_logo'])."' style='max-height:80px'><br>";
  $html .= "<p>".nl2br(htmlspecialchars($org['organization_address'] ?? ''))."</p></div><hr>";
  $html .= "<h3>Invoice #".htmlspecialchars($inv['id'])."</h3>";
  $html .= "<p>Member: ".htmlspecialchars($inv['username'])." (".htmlspecialchars($inv['email']).")</p>";
  $html .= "<p>Amount: ".htmlspecialchars($inv['amount'])." ".htmlspecialchars($inv['currency'])."</p>";
  $html .= "<p>Status: ".htmlspecialchars($inv['status'])."</p>";
  $html .= "</body></html>";
  $fn = __DIR__.'/../public/uploads/invoice_'. $inv['id'] .'.html'; file_put_contents($fn,$html);
  return $fn;
}
?>